var is_phone_verified = false;
var current_step_number = 1;
var prev_question_tracker = [];
var total_questions = 9;
function validatePhoneUs(phoneNumber) {
    // Regular expression to match the format (XXX) XXX-XXXX
    const phoneRegex = /^\(\d{3}\) \d{3}-\d{4}$/;

    // Test the phone number against the regex
    return phoneRegex.test(phoneNumber);
}

$(function () {
    'use strict';
    $('#SubscriptionID input, #CustomerID input, #NewDailyLeadGoal input, #ScheduledDeactivationDate input, #ScheduledReactivationDate input, #ScheduledActionDate input').on('input', function () {
        // Replace any non-numeric characters
        $(this).val($(this).val().replace(/[^0-9]/g, ''));
    });
    jQuery('#ScheduledDeactivationDate input, #ScheduledReactivationDate input, #ScheduledActionDate input').datetimepicker({
        minDate: 0
    });
    var body = $('body');
    //$('#referrer_url').val(document.referrer);
    function goToNextInput(e) {
        getVerificationCode();

        var key = e.which;
        var t = $(e.target);
        var sia = t.prev('input');
        var sib = t.next('input');

        // if (key != 9 && (key < 48 || key > 57)) {
        // 	e.preventDefault();
        // 	return false;
        // }

        if (key === 9) {
            return true;
        }

        if (key === 8) {
            if (!sia || !sia.length) {
                sia = body.find('input').eq(0);
            }
            sia.select().focus();
        } else {
            if (!sib || !sib.length) {
                sib = body.find('input').eq(0);
            }
            sib.select().focus();
        }

    }

    function onKeyDown(e) {
        var key = e.which;

        if (key === 8 || key === 9 || ((key >= 48 && key <= 57) || (key >= 96 && key <= 105))) {
            return true;
        }

        e.preventDefault();
        return false;
    }

    function onFocus(e) {
        $(e.target).select();
    }

    body.on('keyup', '.code_section input', goToNextInput);
    body.on('keydown', '.code_section input', onKeyDown);
    body.on('click', '.code_section input', onFocus);

//    $('#utm_industry').val(getUrlParameter('utm_industry'));
//    $('#utm_source').val(getUrlParameter('utm_source'));
//    $('#utm_medium').val(getUrlParameter('utm_medium'));
//    $('#utm_campaign').val(getUrlParameter('utm_campaign'));
//    $('#utm_content').val(getUrlParameter('utm_content'));
//    $('#utm_term').val(getUrlParameter('utm_term'));
//    $('#utm_campaign_id').val(getUrlParameter('utm_campaign_id'));
//    $('#utm_ad_set_id').val(getUrlParameter('utm_ad_set_id'));
//    $('#utm_ad_id').val(getUrlParameter('utm_ad_id'));
//    $('#from_url').val(window.top.location);
//    $('#referrer_url').val(window.top.location);
});

function getVerificationCode() {
    verification_code = '';
    $('.code_section input').each(function () {
        verification_code += $(this).val();
    });

    console.log('verification_code', verification_code);
//    if (verification_code.length == 6) {
//        $('#verify-code').removeAttr('disabled');
//    } else {
//        $('#verify-code').attr('disabled', 'disabled');
//    }
    $('#verify-code').removeAttr('disabled');
    return verification_code;
}

$(document).ready(function () {
    $('#verify-code').addClass('d-none');
    $('.term_privacy_link').addClass('d-none');
    $('#PhoneNumber input').inputmask("(999) 999-9999", {"placeholder": "(xxx) xxx-xxxx"});  //static mask

    $('#RefinancingImportance input').change(function (e) {
        if ($('#RefinancingImportance input:checked').length >= 2) {
            $('#RefinancingImportance input:not(:checked)').attr('disabled', 'disabled');
        } else {
            $('#RefinancingImportance input').removeAttr('disabled');
        }
    });

    $('.answers-container input[type="radio"]').change(function (e) {
        $('#next-question').removeAttr('disabled');
        $('#next-question').click();
    });
    $('#ScheduledDeactivationDate input, #ScheduledReactivationDate input, #ScheduledActionDate input').change(function (e) {
        $('#next-question').removeAttr('disabled');
    });
    $('.answers-container input[type="checkbox"]').change(function (e) {
        if ($('.question.active').find('input:checked').length) {
            if ($('.question.active').data('selection') === undefined || ($('.question.active').find('input:checked').length == $('.question.active').data('selection'))) {
                $('#next-question').removeAttr('disabled');
                //$('#next-question').click();
            }
        } else {
            $('#next-question').attr('disabled', 'disabled');
        }
    });

    $("body").on("keyup", function (e) {
        if (e.key == 'Enter') {
            var q_type = $('.question.active').data('type');
            if (q_type == 'radio' || q_type == 'checkbox') {
                if ($('.question.active').find('input:checked').length) {
                    e.preventDefault();
                    //$('#next-question').click();
                }
            } else { // input
                if ($('.question.active').find('input').val() != '') {
                    e.preventDefault();
                    $('#next-question').click();
                }
            }
        }
    });

    $('.question input').keyup(function (e) {

        validateData(1);
        if (e.key == 'Enter') {
            if ($(this).val() != '') {

                // if ( $('.question.active').attr('id') == 'PhoneNumber' ) {
                // 	calculateProgress();
                // } else {
                e.stopPropagation();

                if ($('.question.active').attr('id') == 'final')
                {
                    $('#verify-code').click();
                } else
                {
                    $('#next-question').click();
                }
                // }

            }

        }
    });

    $('.question input[inputmode="numeric"]').keyup(function (e) {
        var input = $(this).val();
        input = input.replace(/[^0-9]/g, '');
        $(this).val(input);
    });

    $('.question input[data-convert-amount]').keyup(function (e) {
        var entered_amount = $(this).val();
        if (entered_amount != '') {
            entered_amount = convertAmount(entered_amount);
            $(this).val(entered_amount);
        }
    });

    $('.question input[type="radio"], .question input[type="checkbox"]').change(function (e) {
        validateData();
    });

    $('.question input').blur(function (e) {
        validateData();

        calculateProgress();
    });

    $('.question select').change(function (e) {
        validateData();

        calculateProgress();
    });

    function next_step() {
        if (validateData()) {
            return;
        }
        if ($('.question.active').data('type') == 'radio') {
            var next_question = $('.question.active').find('input:checked').data('next');
        } else if ($('.question.active').data('type') == 'select') {
            var next_question = $('.question.active').find(':selected').data('next');
        } else { // q-type input
            var next_question = $('.question.active').data('next');
        }
        if (next_question == '#final') {
            $('#next-question').addClass('d-none');
            $('#verify-code').removeClass('d-none');
        }

        var q_ids = [];
        $('.question.active').each(function () {
            q_ids.push('#' + $(this).attr('id'));
        });
        prev_question_tracker.push(q_ids.join(', '));

        $('.question.active').removeClass('active');
        $(next_question).addClass('active');

        $('#prev-question').removeClass('d-none');

        $('.question.active').each(function () {
            $(this).find('.current_step_number').html(++current_step_number);
        });

        if ($('.question.active').attr('id') == 'final') {
            // $('#next-question').attr('disabled', 'disabled');
            $('#next-question').addClass('d-none');
            // $('#prev-question').addClass('d-none');
        }
        validateData();

        $('.question.active').first().find('input').first().focus();
        $('#SubscriptionID .top_title span.team').html($('#TeamMember select').val());
        $('span.updatetype_step').html($('#UpdateType select').val());
        calculateProgress();
    }

    $('#next-question').click(function (e) {
        if ($('#SubscriptionID').hasClass('active')) {
            //get data from Airtable
            var data = {
                SubscriptionID: $('#SubscriptionID input').val(),
                CustomerID: $('#CustomerID input').val()
            };
            $('.loader').show();
            $.ajax({
                type: "POST",
                url: 'ajax.php',
                data: data,
                dataType: 'json',
                success: function (res) {
                    $('#ConfirmDetails span.organisation').html(res.organisation);
                    $('#ConfirmDetails span.industry').html(res.industry);
                    $('#ConfirmDetails span.targetregion').html(res.targetregion);
                    $('#ConfirmDetails span.targetstate').html(res.targetstate);

                    $('#final span.organisation').html(res.organisation);
                    $('#final span.industry').html(res.industry);
                    $('#final span.targetregion').html(res.targetregion);
                    $('#final span.targetstate').html(res.targetstate);

                    $('#LeadGoalChange span.DailyLeadGoal').html(res.DailyLeadGoal);
                    $('#EmailNotification span.DailyLeadGoal').html(res.DailyLeadGoal);
                    //set value to hidden field to use on final
                    $('#organisation').val(res.organisation);
                    $('#industry').val(res.industry);
                    $('#targetregion').val(res.targetregion);
                    $('#targetstate').val(res.targetstate);
                    $('#DailyLeadGoal').val(res.DailyLeadGoal);
                    /////////////////
                    //end
                    if (res.organisation != '') {
                        next_step();
                    } else {
                        $('#SubscriptionID').find('.error-holder').html('<i class="fa fa-warning"></i> Oops, That Doesn’t Look Quite Right').css('display', 'inline-block');
                        $('#CustomerID').find('.error-holder').html('<i class="fa fa-warning"></i> Oops, That Doesn’t Look Quite Right').css('display', 'inline-block');
                    }
                    $('.loader').hide();
                },
                error: function (error) {
                    $('.loader').hide();
                }
            });
            ///end
        } else {
            next_step();
        }
        $('#final span.updatetype').html($('#UpdateType select').val());
    });

    $('#prev-question').click(function (e) {
        var prev_question = prev_question_tracker.pop();
        $('.question.active').each(function () {
            --current_step_number;
        });
        $('.question.active').removeClass('active');
        $(prev_question).addClass('active');
        $('.question.active').each(function () {
            --current_step_number;
        });
        $('.question.active').each(function () {
            $(this).find('.current_step_number').html(++current_step_number);
        });

        if (!prev_question_tracker.length) {
            $('#prev-question').addClass('d-none');
        }

        $('#next-question').removeAttr('disabled').removeClass('d-none');


        validateData();

        $('.question.active').first().find('input').first().focus();
        calculateProgress();
        $('#verify-code').addClass('d-none');
        $('.term_privacy_link').addClass('d-none');
    });
});

function calculateProgress()
{
    var update_type = $('#UpdateType').find(':selected').attr('value');
    if (update_type == 'Deactivate Subscription') {
        total_questions = 7;
    } else if (update_type == 'Reactivate Subscription') {
        total_questions = 7;
    } else if (update_type == 'Change Goal Volumes') {
        total_questions = 7;
    } else if (update_type != '') {
        total_questions = 6;
    }
    //console.log(total_questions);
    var questions = [];
    var q_answered = 0;

    var next_question = '#TeamMember';
    var q1 = $(next_question).find(':selected').attr('value');
    //console.log(q1);
    if (q1.length)
    {

        var has_radio_val = true;
        var has_multiple = false;
        var sub_next_questions = [];
        let current_sub_question = 0;

        while (next_question !== undefined && has_radio_val && next_question != '#final')
        {
            if (has_multiple)
            {
                current_sub_question += 1;

                if (current_sub_question == sub_next_questions.length)
                {
                    current_sub_question = 0;
                    has_multiple = false;
                    next_question = $(next_question).data('next');

                    if (next_question == '#final')
                    {
                        break;
                    }
                } else
                {
                    next_question = sub_next_questions[current_sub_question];
                }
            }

            if (next_question !== undefined && next_question.includes(', ') && !has_multiple)
            {
                sub_next_questions = next_question.split(', ');
                next_question = sub_next_questions[0];
                has_multiple = true;
            }

            if ($(next_question).data('type') == 'radio')
            {
                var checked = $(next_question).find('input:checked');
                if (!$(checked).length) {
                    if ($(checked).data('skips') !== undefined) {
                        has_radio_val = false;
                    }
                } else {
                    var q_skips = $(checked).data('skips');
                    total_questions -= parseInt(q_skips);
                    var question = $(next_question).find('.question-title').data('title');
                    questions.push({question: question, answer: $(checked).val(), name: $(checked).attr('name')});

                }
                //next_question = $(checked).data('next');
                next_question = $(checked);
                //console.log($(checked).attr('name') + '=' + $(checked).val());
            } else if ($(next_question).data('type') == 'checkbox')
            {
                var checked = $(next_question).find('input:checked');
                if ($(checked).length) {
                    var checkboxes_answers = '';
                    $(checked).each(function () {
                        checkboxes_answers += $(this).val() + ' & ';
                    });
                    if (checkboxes_answers != '') {
                        checkboxes_answers = checkboxes_answers.substring(0, checkboxes_answers.length - 3);
                    }

                    var question = $(next_question).find('.question-title').data('title');
                    questions.push({question: question, answer: checkboxes_answers, name: $(checked).attr('name')});

                }
            } else if ($(next_question).data('type') == 'select')
            {
                var select = $(next_question).find('select');
                var selected = $(select).find(":selected");
                if (select.length && $(selected).val() != '') {
                    var question = $(next_question).find('.question-title').data('title');
                    questions.push({question: question, answer: $(selected).val(), name: $(select).attr('name')});
                }
                next_question = $(selected);
                //console.log($(select).attr('name') + '=' + $(selected).val());
                //for case if select customized with select icons
//                var input = $(next_question).find('input');
//                var entered_value = $(input).val();
//                if (input.length && entered_value != '') {
//                    var question = $(next_question).find('.question-title').data('title');
//                    questions.push({question: question, answer: entered_value, name: $(input).attr('name')});
//                }
            } else if ($(next_question).data('type') == 'label')
            {
                //don't need do anything
            } else
            {
                var input = $(next_question).find('input');
                var entered_value = $(input).val();
                if (entered_value != '' && $(input).attr('name') !== undefined) {
                    var question = $(next_question).find('.question-title').data('title');
                    if ($(input).data('icon') !== undefined) {
                        if ($(input).data('icon') == 'icon-dollar') {
                            entered_value = '$ ' + entered_value;
                        } else if ($(input).data('icon') == 'icon-percent') {
                            entered_value = entered_value + '%';
                        }
                    }
                    //console.log($(input).attr('name') + '=' + entered_value);
                    questions.push({question: question, answer: entered_value, name: $(input).attr('name')});
                }
                //console.log('Next:' + next_question);
            }

            if (!has_multiple)
            {
                next_question = $(next_question).data('next');
            }
        }

        q_answered = questions.length;
        var percentage = Math.round((q_answered / total_questions) * 100);

        $('#progress-bar').css('width', percentage + '%');
        $('#percentage').html(percentage);
    } else
    {
        $('#progress-bar').css('width', '0px');
    }

    return {
        total_questions: total_questions,
        q_answered: q_answered,
        questions: questions,
    };
}
function IsvalidDomain(the_domain) {
    if (the_domain == 'N/A') {
        return true;
    }
// strip off "http://" and/or "www."
    the_domain = the_domain.replace("https://", "");
    the_domain = the_domain.replace("http://", "");
    the_domain = the_domain.replace("www.", "");

    var reg = /^[a-zA-Z0-9][a-zA-Z0-9-]{1,61}[a-zA-Z0-9]\.[a-zA-Z]{2,}$/;
    var check1 = reg.test(the_domain);
    var reg = /^[a-zA-Z0-9][a-zA-Z0-9-]{1,61}[a-zA-Z0-9]\.[a-zA-Z]{2,}\.[a-zA-Z]{2,}$/;
    var check12 = reg.test(the_domain);
    return check1 || check12;
}
function validateData(hide_error) {
    if (hide_error === undefined) {
        hide_error = 0;
    }
    $('.question.active .error-holder').hide().html('');
    $('#next-question').removeAttr('disabled');
    var has_error = false;
    var show_phone_enter_btn = false;

    $('.question.active').each(function () {
        var q_type = $(this).data('type');
        if (q_type == 'radio' || q_type == 'checkbox') {
            if (!$(this).find('input:checked').length) {
                has_error = true;
            }
        } else if ($(this).find('select').length) {
            if ($(this).find('select').val() == '') {
                has_error = true;
            }
        } else { // input
            var input_value = $(this).find('input').val();
            if (input_value == '') {
                has_error = true;
            } else if ($(this).find('input').data('min') !== undefined && $(this).find('input').data('max') !== undefined) {
                var min = min_str = $(this).find('input').data('min');
                var max = max_str = $(this).find('input').data('max');
                if ($(this).find('input').data('convert-amount') !== undefined) {
                    input_value = input_value.replace(/,/g, '');
                    //input_value = input_value.replace(/./g, '');
                    min_str = convertAmount(min);
                    max_str = convertAmount(max);
                }
                var number_value = parseInt(input_value);
                if (number_value < min || number_value > max) {
                    if (!hide_error) {
                        $(this).find('.error-holder').html('<i class="fa fa-warning"></i> Please enter a number between ' + min_str + ' and ' + max_str + '').css('display', 'inline-block');
                    }
                    has_error = true;
                }
            } else if ($(this).find('input').attr('minLength') !== undefined && $(this).find('input').attr('maxLength') !== undefined) {
                var minLength = $(this).find('input').attr('minLength');
                var maxLength = $(this).find('input').attr('maxLength');
                var current_length = input_value.length;
                if (current_length < minLength || current_length > maxLength) {
                    if (!hide_error) {
                        $(this).find('.error-holder').html('<i class="fa fa-warning"></i> Post code should be  between ' + minLength + ' and ' + maxLength + '').css('display', 'inline-block');
                    }
                    has_error = true;
                }
            } else if ($(this).find('input').attr('name') == 'SubscriptionID' || $(this).find('input').attr('name') == 'CustomerID') {
                if (!validateSubscriptionID(input_value)) {
                    if (!hide_error) {
                        $(this).find('.error-holder').html('<i class="fa fa-warning"></i> Oops, That Doesn’t Look Quite Right').css('display', 'inline-block');
                    }
                    has_error = true;
                }
            } else if ($(this).find('input').attr('name') == 'NewDailyLeadGoal') {
                if (!validateNumberLead(input_value)) {
                    if (!hide_error) {
                        $(this).find('.error-holder').html('<i class="fa fa-warning"></i> Oops, must be a number between 0 and 100').css('display', 'inline-block');
                    }
                    has_error = true;
                }
            } else if ($(this).find('input').data('phone') !== undefined && !is_phone_verified) {
                if (!$('#PhoneNumber input').inputmask("isComplete")) {
                    // show_phone_enter_btn = true;
                    has_error = true;
                }

            }
        }
    });

    if (has_error) {
        $('#next-question').attr('disabled', 'disabled');
    }
    // var answer_confirm = $('.question.active:not(#final)').find('.answer-confirm');
    // if ( !has_error ) { // if no error found
    // 	if ( q_type == 'radio' || q_type == 'checkbox' ) {
    // 		var has_value = $('.question.active').find('input:checked').length;
    // 	} else {
    // 		var has_value = $('.question.active').find('input').val();
    // 	}
    // 	if ( has_value ) {
    // 		$(answer_confirm).fadeIn('fast');
    // 	} else {
    // 		$(answer_confirm).fadeOut('fast');
    // 	}
    // } else {
    // 	if (show_phone_enter_btn) {
    // 		$(answer_confirm).fadeIn('fast');
    // 	} else {
    // 		$(answer_confirm).fadeOut('fast');
    // 	}
    // }

    return has_error;
}

function validateEmail(email) {
    const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
}
function validateSubscriptionID(input) {
    const regex = /^\d{8}$/; // Regular expression for exactly 8 digits
    return regex.test(input);
}
function validateNumberLead(input) {
    const number = parseFloat(input);
    if (!isNaN(number) && number >= 0 && number <= 100) {
        return true; // Valid number
    }
    return false; // Invalid number
}
function sendCode() {
    $('#verify-code').removeClass('d-none');
}
function verifyCode() {
    var verification_code = '123456';
    if (verification_code.length == 6) {

        var results = calculateProgress();
        if ((results.total_questions - 1) > results.q_answered) {
            $('.question.active .error-holder').html('<i class="fa fa-warning"></i> Please answer all questions').css('display', 'inline-block');
            return false;
        }
        //$('#verify-code').attr('disabled', 'disabled');

        var questions = results.questions;

        var wh_data = {
            Organisation: $('#organisation').val(),
            Industry: $('#industry').val(),
            TargetRegion: $('#targetregion').val(),
            TargetState: $('#targetstate').val(),
            DailyLeadGoal: $('#DailyLeadGoal').val(),
        };
        if ($('#UpdateType select').val() == 'Change Goal Volumes') {
            var wh_data = {
                NewDailyLeadGoal: $('#NewDailyLeadGoal input').val(),
                Organisation: $('#organisation').val(),
                Industry: $('#industry').val(),
                TargetRegion: $('#targetregion').val(),
                TargetState: $('#targetstate').val(),
                DailyLeadGoal: $('#DailyLeadGoal').val(),
            };
        }
        var additional_params = jQuery.param(wh_data);
        questions.forEach(function (elem) {
            if (elem.name != undefined) {
                additional_params += '&' + elem.name + '=' + encodeURIComponent(elem.answer);
            }
        });

        var data = {
            action: 'submit-questions',
            questions: questions,
            code: verification_code,
            wh_url: 'https://hooks.zapier.com/hooks/catch/695165/2ie6l9r/?' + additional_params
        };

        // Clear all errors before ajax request
        $('.error-holder').html('');
        $.ajax({
            type: "POST",
            url: 'process.php',
            data: data,
            dataType: 'json',
            success: function (res) {
                console.log(res);
                if (res.is_error) {
                    $('#verify-code').removeAttr('disabled');
                    $('.question.active .error-holder').html('<i class="fa fa-warning"></i> ' + res.message).css('display', 'inline-block');
                    $('#resend-code').show();
                } else { // Email sent successfully
                    console.log(res);
                    window.parent.postMessage({redirect: res.thank_page}, "*");
                    window.top.location.href = res.thank_page;
                }
            },
            error: function (error) {
                $('#verify-code').removeAttr('disabled');
                $('.question.active .error-holder').html('<i class="fa fa-warning"></i> There was some problem').css('display', 'inline-block');
            }
        });
    }
}

var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = window.top.location.search.substring(1),
            sURLVariables = sPageURL.split('&'),
            sParameterName,
            i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
    return false;
};

function convertAmount(amount) {
    if (amount != '') {
        if (typeof amount === 'number') {
            amount = amount + '';
        }
        amount = amount.replace(/[^0-9]/g, '');

        amount = amount.replace(/,/g, '');
        amount = parseInt(amount);
        amount = amount.toLocaleString();
    }
    return amount;
}