<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>Admin Form | LeadsHQ</title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="https://d9hhrg4mnvzow.cloudfront.net/try.leadshq.com.au/solar/6f834972-lhq-icon-webclip_1000000000000000000028.png" />
        <!-- Fontawesome -->
        <link href="css/font-awesome-4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Google fonts-->
        <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet" type="text/css" />
        <!-- Bootstrap-->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
        <!-- Core theme CSS-->
        <link href="js/jquery.datetimepicker.min.css?version=<?php echo microtime(); ?>" rel="stylesheet" />
        <link href="style.css?version=<?php echo microtime(); ?>" rel="stylesheet" />
    </head>

    <body>
        <?php
        $questions = [
            'TeamMember' => [
                'type' => 'select',
                'title' => 'Which <strong>team member</strong> is making this update? *',
                'sub_title' => 'Please select the best option.',
                'options' => [
                    'a' => ['title' => 'Mori', 'next' => '#SubscriptionID, #CustomerID', 'icon' => '', 'skips' => 0],
                    'b' => ['title' => 'Matt D', 'next' => '#SubscriptionID, #CustomerID', 'icon' => '', 'skips' => 0],
                    'c' => ['title' => 'Matt A', 'next' => '#SubscriptionID, #CustomerID', 'icon' => '', 'skips' => 0],
                    'd' => ['title' => 'Dan', 'next' => '#SubscriptionID, #CustomerID', 'icon' => '', 'skips' => 0],
                    'e' => ['title' => 'Patty', 'next' => '#SubscriptionID, #CustomerID', 'icon' => '', 'skips' => 0],
                ],
                'next' => '#SubscriptionID, #CustomerID',
                'extra_class' => ''
            ],
            'SubscriptionID' => [
                'type' => 'text',
                'title' => "Subscription ID",
                'placeholder' => 'Subscription ID',
                'next' => '#ConfirmDetails',
                'required' => 1,
                'top_title' => 'Hi <span class="team">team</span>, what <strong>subscription</strong> would you like to update? *',
                'top_title_sub' => 'Please enter these details carefully.',
                'maxLength' => 8
            ],
            'CustomerID' => [
                'type' => 'text',
                'title' => "Customer ID",
                'placeholder' => 'Customer ID',
                'next' => '#ConfirmDetails',
                'extra_class_question' => '',
                'maxLength' => 8
            ],
            'ConfirmDetails' => [
                'type' => 'label',
                'title' => "Please Confirm The Subscription Details",
                'sub_title' => "I would like to update <span class='organisation'></span>'s <span class='industry'></span> subscription for <span class='targetregion'></span> <span class='targetstate'></span>.",
                'next' => '#UpdateType',
            ],
            'UpdateType' => [
                'type' => 'select',
                'title' => 'What <strong>type of update</strong> would you like to make? *',
                'sub_title' => 'Please select your best option',
                'options' => [
                    'a' => ['title' => 'Deactivate Subscription', 'next' => '#UpdateTiming', 'icon' => '', 'skips' => 0],
                    'b' => ['title' => 'Reactivate Subscription', 'next' => '#UpdateTiming', 'icon' => '', 'skips' => 0],
                    'c' => ['title' => 'Change Goal Volumes', 'next' => '#LeadGoalChange', 'icon' => '', 'skips' => 0],
                    'd' => ['title' => 'Change Target Postcodes (tbc)', 'next' => '#UpdateTiming', 'icon' => '', 'skips' => 0],
                    'e' => ['title' => 'Change Lead Distribution (tbc)', 'next' => '#UpdateTiming', 'icon' => '', 'skips' => 0],
                    'f' => ['title' => 'Place Renewal On Hold (tbc)', 'next' => '#UpdateTiming', 'icon' => '', 'skips' => 0],
                ],
                'next' => '',
                'extra_class' => ''
            ],
            'LeadGoalChange' => [
                'type' => 'radio',
                'title' => 'Would you like to <strong>increase or decrease</strong> this amount?',
                'sub_title' => "Please select your best option",
                'options' => [
                    'a' => ['title' => 'Increase', 'next' => '#NewDailyLeadGoal', 'icon' => '<i class="fa fa-arrow-up" aria-hidden="true"></i>', 'skips' => 0],
                    'b' => ['title' => 'Decrease', 'next' => '#NewDailyLeadGoal', 'icon' => '<i class="fa fa-arrow-down" aria-hidden="true"></i>', 'skips' => 0],
                ],
                'extra_class' => ' has_icon',
                'next' => '#NewDailyLeadGoal',
                'top_title' => 'This subscription currently has a daily volume goal of <span class="DailyLeadGoal"></span>.'
            ],
            'NewDailyLeadGoal' => [
                'type' => 'text',
                'title' => "What would you like the new <strong>daily lead goal</strong> to be?*",
                'placeholder' => '',
                'next' => '#UpdateTiming',
                'required' => 1,
                'maxLength' => 3
            ],
            'UpdateTiming' => [
                'type' => 'radio',
                'title' => "What would you like the <strong>timing of this update</strong> (<span class='updatetype_step'>UpdateType</span>)? *",
                'sub_title' => "Please select your best option",
                'options' => [
                    'a' => ['title' => 'Immediate', 'next' => '#EmailNotification', 'icon' => '<i class="fa fa-fast-forward" aria-hidden="true"></i>', 'skips' => 0],
                    'b' => ['title' => 'Scheduled', 'next' => '#ScheduledActionDate', 'icon' => '<i class="fa fa-calendar" aria-hidden="true"></i>', 'skips' => 0],
                ],
                'extra_class' => ' has_icon',
                'next' => ''
            ],
            'ScheduledActionDate' => [
                'type' => 'text',
                'title' => "What <strong>date and time</strong> would you like?",
                'placeholder' => '',
                'next' => '#EmailNotification',
                'required' => 1,
            ],
            'EmailNotification' => [
                'type' => 'radio',
                'title' => 'Would you like to <strong>inform the client about this update via email? *</strong>',
                'sub_title' => "Please select your best option",
                'options' => [
                    'a' => ['title' => 'Yes', 'next' => '#final', 'icon' => '<i class="fa fa-check" aria-hidden="true"></i>', 'skips' => 0],
                    'b' => ['title' => 'No', 'next' => '#final', 'icon' => '<i class="fa fa-times" aria-hidden="true"></i>', 'skips' => 0],
                ],
                'extra_class' => ' has_icon',
                'next' => '#final',
                'top_title' => 'This subscription currently has a daily volume goal of <span class="DailyLeadGoal"></span>.'
            ]
        ];
        ?>

        <!-- Form -->
        <section class="questions" style="padding-bottom:20px;background: #f9f9f9;">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="progress">
                            <div id="progress-bar" class="progress-bar bg-primary" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <form action="process.php" method="post" novalidate="">
                            <input type="hidden" id="organisation" name="organisation" value="">
                            <input type="hidden" id="industry" name="industry" value="">
                            <input type="hidden" id="targetregion" name="targetregion" value="">
                            <input type="hidden" id="targetstate" name="targetstate" value="">
                            <input type="hidden" id="DailyLeadGoal" name="DailyLeadGoal" value="">
                            <?php foreach ($questions as $key => $question) { ?>
                                <div id="<?= $key ?>" class="question <?= $key == 'TeamMember' ? 'active' : '' ?> <?php if (isset($question['extra_class_question'])) echo $question['extra_class_question']; ?>" data-type="<?= $question['type'] ?>" <?= isset($question['next']) ? 'data-next="' . $question['next'] . '"' : '' ?> <?= isset($question['selection']) ? 'data-selection="' . $question['selection'] . '"' : '' ?> >
                                    <?= isset($question['top_title']) ? '<p class="top_title">' . $question['top_title'] . '</p>' : '' ?>
                                    <?= isset($question['top_title_sub']) ? '<p class="top_title_sub">' . $question['top_title_sub'] . '</p>' : '' ?>
                                    <label class="question-title <?php if (isset($question['extra_class'])) echo $question['extra_class']; ?>" data-title="<?= $question['title'] ?>">
                                        <span><strong class="current_step_number">1</strong> <i class="fa fa-arrow-right fa-xs"></i> </span>
                                        <?= $question['title'] ?>
                                    </label>
                                    <?= isset($question['sub_title']) ? '<p>' . $question['sub_title'] . '</p>' : '' ?>

                                    <?= isset($question['instructions']) ? '<p>' . $question['instructions'] . '</p>' : '' ?>

                                    <div class="answers-container <?= isset($question['icon']) ? $question['icon'] : '' ?>">
                                        <?php if ($question['type'] == 'radio' || $question['type'] == 'checkbox') { ?>
                                            <ul>
                                                <?php foreach ($question['options'] as $index => $option) { ?>
                                                    <li>
                                                        <input type="<?= $question['type'] ?>" name="<?= $key ?>" <?= isset($option['next']) ? 'data-next="' . $option['next'] . '"' : '' ?> data-skips="<?= $option['skips'] ?? 0 ?>" id="question-<?= $key ?>-answer-<?= $index ?>" value="<?= $option['title'] ?>">
                                                        <label for="question-<?= $key ?>-answer-<?= $index ?>"><?php if (isset($option['icon'])) echo $option['icon']; ?><?= $option['title'] ?></label>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        <?php } else if ($question['type'] == 'select') { ?>
                                            <select name="<?= $key ?>" <?= isset($question['required']) ? 'required' : '' ?>>
                                                <option value="">Please choose</option>
                                                <?php foreach ($question['options'] as $index => $option) { ?>
                                                    <option value="<?= $option['title'] ?>" data-img="<?= $option['icon'] ?>" data-next="<?= $option['next'] ?>"><?= $option['title'] ?></option>
                                                <?php } ?>
                                            </select>
                                            <?php
                                        } else if ($question['type'] == 'label') {
                                            //don't need show anything
                                        } else {
                                            ?>
                                            <input type="<?= isset($question['type']) ? $question['type'] : 'text' ?>" name="<?= $key ?>" placeholder="<?= $question['placeholder'] ?>" <?= isset($question['required']) ? 'required' : '' ?> <?= isset($question['min']) ? 'data-min="' . $question['min'] . '"' : '' ?> <?= isset($question['max']) ? 'data-max="' . $question['max'] . '"' : '' ?> <?= isset($question['minLength']) ? 'minLength="' . $question['minLength'] . '"' : '' ?>  <?= isset($question['maxLength']) ? 'maxLength="' . $question['maxLength'] . '"' : '' ?> <?= isset($question['is_phone_number']) ? 'data-phone="1"' : '' ?> <?= isset($question['convert_amount']) ? 'data-convert-amount="1"' : '' ?> <?= isset($question['convert_amount']) || isset($question['is_phone_number']) ? 'inputmode="numeric"' : '' ?> <?= isset($question['icon']) ? 'data-icon="' . $question['icon'] . '"' : '' ?> id="<?php echo $key . '-field'; ?>" autocomplete="off">
                                            <br/>
                                            <div class="error-holder" style="display: none;"></div>
                                            <?php
                                            if ($key == 'Website') {
                                                ?>
                                                <div>
                                                    <a class="not_website" href="javascript:;">I Don’t Have One Yet</a>
                                                </div>
                                                <?php
                                            }
                                            ?>
                                        <?php } ?>

                                    </div>

                                </div>

                            <?php } ?>

                            <div id="final" class="question">
                                <label class="question-title">
                                    Please Confirm Your Update
                                </label>
                                <div class="answers-container">
                                    <div class="code_section">
                                        <div class="form-group">
                                            Confirming that you would like to <span class="updatetype"></span> for <span class='organisation'></span>’s <span class='industry'></span> subscription for <span class='targetregion'></span> <span class='targetstate'></span>. 
                                        </div>
                                        <div class="error-holder"></div>
                                        <button style="display: none;" id="resend-code" type="button" class="btn btn-warning" onclick="this.disabled = true;
                                                sendCode();" style="display: none;">Resend code</button>

                                    </div>
                                </div>
                            </div>
                            <div class="row action_row">
                                <div class="col-12 action-buttons">
                                    <div class="loader"></div>
                                    <button id="next-question" type="button" class="btn btn-primary" disabled>Yes, Continue</button>
                                    <button style="background-color: #0135ff; border-radius: 30px; border: none; padding: 15px 30px 15px 30px;font-size: 18px;font-weight: 600;" id="verify-code" type="button" class="btn btn-primary d-none" onclick="verifyCode();">Yes, Make This Update</button>
                                </div>
                                <div class="col-12 action-buttons" style="margin-top: 10px;">
                                    <button id="prev-question" type="button" class="btn btn-secondary btn-sm d-none">No, Go Back</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 offset-md-7">
                    </div>
                </div>
            </div>
        </section>

        <!-- Form End--> 

        <!-- jQuery first, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
        <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script> -->
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
        <script src="js/jquery.inputmask.min.js"></script>
        <script src="js/jquery.datetimepicker.full.min.js"></script>
        <!-- Core theme JS-->
        <script src="custom.js?version=<?php echo microtime(); ?>"></script>
    </body>
</html>