<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require __DIR__ . '/vendor/autoload.php';

use Twilio\Rest\Client;

// Prevent problems with iframes
ini_set('session.cookie_samesite', 'None');
// Start the session
session_start();

if (!$action = filter_input(INPUT_POST, 'action')) {
    echo json_encode(['is_error' => 1, 'message' => 'Invalid Request']);
    exit;
}

if ($action == 'submit-questions') {
    echo submitQuestions();
    exit;
} else if ($action == 'send-code') {
    echo sendCode();
    exit;
} else if ($action == 'verify-code') {
    echo verifyCode();
    exit;
}

function getAnswer($questions, $name) {
    foreach ($questions as $question) {
        if ($question["name"] == $name) {
            return $question["answer"];
        }
    }

    return null;
}

function getValueFromAssoc($assocArray, $searchKey) {
    foreach ($assocArray as $key => $value) {
        if ($searchKey == $key) {
            return $value;
        }
    }

    return null;
}

function submitQuestions() {

    if (!$questions = filter_input(INPUT_POST, 'questions', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY)) {
        return json_encode(['is_error' => 1, 'message' => 'Please answer all questions']);
    }

    if (!$wh_url = filter_input(INPUT_POST, 'wh_url')) {
        return json_encode(['is_error' => 1, 'message' => 'Webhook URL not found.']);
    }

    // Check if all questions have answers
    foreach ($questions as $question) {
        if (empty($question['question']) || empty($question['answer'])) {
            return json_encode(['is_error' => 1, 'message' => 'Please answer all questions']);
        }
    }
    $parts = parse_url($wh_url);
    parse_str($parts['query'], $params);
    $email_body = "";

    $email_body .= "<strong>New admin update completed by " . getAnswer($questions, "TeamMember") . ":</strong><br/>\n";
    $email_body .= "<ul>\n";
    $email_body .= "<li>SubscriptionID: " . getAnswer($questions, "SubscriptionID") . "</li>";
    $email_body .= "<li>CustomerID: " . getAnswer($questions, "CustomerID") . "</li>";
    $email_body .= "<li>Update Type: " . getAnswer($questions, "UpdateType") . "</li>";
    if (getValueFromAssoc($params, "LeadGoalChange") != '') {
        $email_body .= "<li>LeadGoalChange: " . getValueFromAssoc($params, "LeadGoalChange") . "</li>";
    }
    if (getValueFromAssoc($params, "NewDailyLeadGoal") != '') {
        $email_body .= "<li>NewDailyLeadGoal: " . getValueFromAssoc($params, "NewDailyLeadGoal") . "</li>";
    }
    $email_body .= "<li>UpdateTiming: " . getValueFromAssoc($params, "UpdateTiming") . "</li>";
    if (getValueFromAssoc($params, "ScheduledActionDate") != '') {
        $email_body .= "<li>Scheduled Action Date: " . getValueFromAssoc($params, "ScheduledActionDate") . "</li>";
    }
    $email_body .= "<li>Email Notification: " . getValueFromAssoc($params, "EmailNotification") . "</li>";
    $email_body .= "<li>Organisation: " . getValueFromAssoc($params, "Organisation") . "</li>";
    $email_body .= "<li>Industry: " . getValueFromAssoc($params, "Industry") . "</li>";
    $email_body .= "<li>Target Region: " . getValueFromAssoc($params, "TargetRegion") . "</li>";
    $email_body .= "<li>Target State: " . getValueFromAssoc($params, "TargetState") . "</li>";
    $email_body .= "<li>DailyLeadGoal: " . getValueFromAssoc($params, "DailyLeadGoal") . "</li>";
    $email_body .= "</ul>\n";
    // Success response from last step of email sending
    return sendEmail($email_body);
}

function sendGridSendEmail($toAddress, $fromName, $fromAddress, $subject, $htmlBody) {
    $request = [
        "personalizations" => [
            [
                "to" => [
                    ["email" => $toAddress, "name" => $toAddress]
                ]
            ]
        ],
        "from" => [
            "email" => $fromAddress,
            "name" => $fromName
        ],
        "subject" => $subject,
        "content" => [
            [
                "type" => "text/html",
                "value" => $htmlBody
            ]
        ]
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.sendgrid.com/v3/mail/send");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["content-type: application/json", "Authorization: Bearer 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"]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($request));

    $result = curl_exec($ch);

    return $result;
}

function sendEmail($email_body) {
    if (!$wh_url = filter_input(INPUT_POST, 'wh_url')) {
        return json_encode(['is_error' => 1, 'message' => 'Webhook URL not found.']);
    }

    try {

        $fromName = "LeadsHQ Leads";
        $fromAddress = "leads@leadshq.com.au";
        $subject = "[LeadsHQ] New Admin Update";

        sendGridSendEmail("hi@leadshq.com.au", $fromName, $fromAddress, $subject, $email_body);

        file_get_contents($wh_url);
        unset($_COOKIE['code']);

        //thank page url
        if (!$questions = filter_input(INPUT_POST, 'questions', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY)) {
            return json_encode(['is_error' => 1, 'message' => 'Please answer all questions']);
        }
        $thank_page = 'https://leadshq.com.au/';
        //end
        return json_encode(['is_error' => 0, 'message' => 'Thanks!', 'thank_page' => $thank_page]);
    } catch (\Throwable $e) {
        return json_encode(['is_error' => 1, 'message' => 'Email sending failed. There was some problem']);
    }
}

?>